DROP PROCEDURE [hips].[EpisodeInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 23 October 2012
-- Description:   Inserts a new record into the Episode Table
-- Modified:    22/11/2012 sbiber added Ward,Room,Bed
-- Modified:    18/12/2012 sbiber changed UploadConsent to ConsentWithdrawn
-- =============================================

CREATE PROCEDURE [hips].[EpisodeInsert] 
(
	@PatientId INT,
	@SourceSystemEpisodeId VARCHAR(100),
	@AdmissionDate DATETIME,
	@AdmissionReason VARCHAR(1000) = NULL,
	@DischargeDate DATETIME = NULL,
	@ResponsibleProviderId INT,
	@EpisodeTypeId INT,
	@EpisodeLifecycleId INT = NULL,
	@ConsentWithdrawn BIT,
	@Ward VARCHAR(40) = NULL,
	@Room VARCHAR(40) = NULL,
	@Bed VARCHAR(40) = NULL,
	@UserModified VARCHAR(256)
) 
AS
BEGIN
	SET NOCOUNT ON

   DECLARE @intErrorCode INT
          , @EpisodeId INT
          
    SET @intErrorCode = 0
	INSERT INTO [hips].[Episode]
	        ( PatientId,
	          SourceSystemEpisodeId,
	          AdmissionDate,
	          AdmissionReason,
	          DischargeDate,
	          ResponsibleProviderId,
	          EpisodeTypeId,
	          EpisodeLifecycleId,
	          ConsentWithdrawn,
			  Ward,
			  Room,
			  Bed,
	          DateCreated,
	          UserCreated,
	          DateModified,
	          UserModified
	        )
	VALUES  ( @PatientId,
	          @SourceSystemEpisodeId, 
	          @AdmissionDate, 
	          @AdmissionReason,
	          @DischargeDate, 
	          @ResponsibleProviderId, 
	          @EpisodeTypeId,
	          @EpisodeLifecycleId,
	          @ConsentWithdrawn,
			  @Ward,
			  @Room,
			  @Bed,
	          GETDATE(), 
	          @UserModified, 
	          GETDATE(), 
	          @UserModified  
	        )
	        
	 SELECT @intErrorCode = @@ERROR , @EpisodeId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
		SELECT e.EpisodeId
			,e.PatientId
			,e.SourceSystemEpisodeId
			,e.AdmissionDate
			,e.AdmissionReason
			,e.DischargeDate
			,e.ResponsibleProviderId
			,e.EpisodeTypeId
			,et.Description AS EpisodeType
			,e.EpisodeLifecycleId
			,ec.Description AS EpisodeLifecycle
			,e.ConsentWithdrawn
			,e.Ward
			,e.Room
			,e.Bed
			,e.DateCreated
			,e.UserCreated
			,e.DateModified
			,e.UserModified
		FROM hips.Episode e
		LEFT JOIN [hips].[EpisodeType] AS et on et.EpisodeTypeId = e.EpisodeTypeId
		LEFT JOIN [hips].[EpisodeLifecycle] AS ec on ec.EpisodeLifecycleId = e.EpisodeLifecycleId
		WHERE @EpisodeId = e.EpisodeId
    END

    RETURN(@intErrorCode)

	

END
GO

